# -*- coding: utf-8 -*-
"""t-SNE.ipynb

Automatically generated by Colab.

Original file is located at
    https://colab.research.google.com/drive/10L0hCd7PSNovFHh2yERoLFUcMcPS2Vvy
"""

from sklearn.datasets import load_digits
digits = load_digits()

import matplotlib.pyplot as plt
fig, ax = plt.subplots(1, 4)
for i in range(4):
  ax[i].imshow(digits.images[i], cmap='Greys')
plt.show()

digits.data.shape

y_digits = digits.target
X_digits = digits.data

from sklearn.manifold import TSNE
tsne = TSNE(n_components=2, init='pca', random_state=123)
X_digits_tsne = tsne.fit_transform(X_digits)

import matplotlib.patheffects as PathEffects
import numpy as np
def plot_projection(x, colors):
  f = plt.figure(figsize=(8, 8))
  ax = plt.subplot(aspect='equal')
  for i in range(10):
    plt.scatter(x[colors == i, 0], x[colors == i, 1])
  for i in range(10):
    xtext, ytext = np.median(x[colors == i, :], axis=0)
    txt = ax.text(xtext, ytext, str(i), fontsize=24)
    txt.set_path_effects([PathEffects.Stroke(linewidth=5, foreground="w"), PathEffects.Normal()])
plot_projection(X_digits_tsne, y_digits)
plt.show()